/*== DIGISTANT 6706  bp6706 Include File ======================*/
#include <vpptype.h>  
/*== defines for serial communication =========================*/
#define NUL      0x00
#define STX      0x02
#define ETX      0x03
#define EOT      0x04
#define ENQ      0x05
#define ACK      0x06
#define CR       0x0D
#define NAK      0x15

/*== defines for program=======================================*/
#define bp6706_MAX_INSTR   10
#define bp6706_MAX_CMD     100
#define bp6706_GPIB        0
#define bp6706_SERIAL      1

#define bp6706_VOLTAGE_ERROR     (1<<0)/* Bit 0 of Questionable Condition Register*/
#define bp6706_CURRENT_ERROR     (1<<1)/* Bit 1 of Questionable Condition Register*/
#define bp6706_DEVICE_DEPT_ERROR (1<<3)/* Bit 3 of Standard Event Register*/
#define bp6706_EXECUTION_ERROR   (1<<4)/* Bit 4 of Standard Event Register*/

/*== GLOBAL FUNCTION DECLARATIONS =========================================*/
int _VI_FUNC bp6706_init_gpib (int address, int reset, char* instrumentIDString,
                               int *instrumentID);
int _VI_FUNC bp6706_init_serial (int COMPort, long baudRate, double timeoutseconds,
                                 int blockCheck, int groupAddress, int userAddress,
                                 char *instrumentIDString, int reset,
                                 int *instrumentID);
int _VI_FUNC bp6706_local_gpib (int instrumentID);
int _VI_FUNC bp6706_set_volt_config (int instrumentID, int voltageRange,
                                     double currentLimitmA, int voltageSense);
int _VI_FUNC bp6706_get_volt_config (int instrumentID, int *voltageRange,
                                     double *currentLimitmA, int *voltageSense);
int _VI_FUNC bp6706_set_curr_config (int instrumentID, int currentRange,
                                     double voltageLimitV);
int _VI_FUNC bp6706_get_curr_config (int instrumentID, int *currentRange,
                                     double *voltageLimitV);
int _VI_FUNC bp6706_set_volt_value (int instrumentID, double voltageValue,
                                    int voltageUnit);
int _VI_FUNC bp6706_get_volt_value (int instrumentID, double *voltageValueV);
int _VI_FUNC bp6706_set_curr_value (int instrumentID, double currentValue,
                                    int currentUnit);
int _VI_FUNC bp6706_get_curr_value (int instrumentID, double *currentValuemA);
int _VI_FUNC bp6706_system_error (int instrumentID, char *systemError);
int _VI_FUNC bp6706_system_keyboard (int instrumentID, int keyboard);
int _VI_FUNC bp6706_send_scpi (int instrumentID, char *sendSCPIMessage);
int _VI_FUNC bp6706_receive_scpi (int instrumentID, char* sendSCPIMessage,
                                  char *instrumentAnswers);
int _VI_FUNC bp6706_close (int instrumentID);

/*
int _VI_FUNC  bp6706_init_gpib (int,int,char*,int*);
int _VI_FUNC  bp6706_init_serial(int ,long,double,int,int,int,char*,int,int *);
int _VI_FUNC  bp6706_local_gpib (int);
int _VI_FUNC  bp6706_set_volt_config(int, int,double,int);
int _VI_FUNC  bp6706_get_volt_config(int,int*,double*,int*);
int _VI_FUNC  bp6706_set_curr_config(int,int,double);
int _VI_FUNC  bp6706_get_curr_config(int,int*,double*);
int _VI_FUNC  bp6706_set_volt_value(int,double,int);
int _VI_FUNC  bp6706_get_volt_value(int,double*);
int _VI_FUNC  bp6706_set_curr_value(int,double,int);
int _VI_FUNC  bp6706_get_curr_value(int,double*);
int _VI_FUNC  bp6706_system_error(int,char*);
int _VI_FUNC  bp6706_system_keyboard(int,int);
int _VI_FUNC  bp6706_cal_state(int,int);
int _VI_FUNC  bp6706_cal_curr_adjust(int,int,int);
int _VI_FUNC  bp6706_cal_volt_adjust(int,int,int);
int _VI_FUNC  bp6706_cal_protect_curr_adjust(int,int);
int _VI_FUNC  bp6706_cal_protect_volt_adjust(int,int);
int _VI_FUNC  bp6706_cal_curr_data(int,int,double,double);
int _VI_FUNC  bp6706_cal_volt_data(int,int,double,double);
int _VI_FUNC  bp6706_cal_protect_curr_data(int,double,double);
int _VI_FUNC  bp6706_cal_protect_volt_data(int,double,double);
int _VI_FUNC  bp6706_send_scpi(int,char*);
int _VI_FUNC  bp6706_receive_scpi(int ,char*,char*);
int _VI_FUNC  bp6706_close (int);
*/
/*=============================== END =====================================*/
